#pure python
##ap = (1,2.3,4)          # defines a tuple
ap = [1,2,3,4, 'a']          # defines a list
##                        # list a has elements 1,2,3 and 4 in python + 'a'
cp = range(20)
print cp


##print ap
##print ap+1              # we can't add a integer to a list.

##bp = [5,6,7]            # creates a list b with elements 1,2,3 and 4 in python
##print ap + bp           # list concatenation

#-------------------------------------------------------------------------------
#        SciPy (toolbox)
#        NumPy
#       Python

#NumPy
# data strucure
# - NDArray class: multi-dimentional array object
# - "Universal Functions" (UFunc): fast array math operations
#  - sine, cosine, add, floor, ...

# Matlab programming in Python
# Developed by Travis Oliphant

#http://scipy.org/Tentative_NumPy_Tutorial
#http://scipy.org/Numpy_Example_List_With_Doc

#-------------------------------------------------------------------------------
# from numpy import *   # Grab all the variables
                        # Bad practice. It is easier for others to read and debug
                        # in the future if you use explicit imports.

#Creating and Displaying arrays
from numpy import array

a = array([1, 2, 3, 4])    # creates an array a with elements 1,2,3 and 4
print a

b = array([5., 6., 7.])      # creates an array b with elements 5,6 and 7
print b

c = array(ap)           # array is a function. Cast the list ap to an array
print c

A = array([ (1.5, 2, 3), (4, 5, 6) , (1, 7, .8)])
print A

print '------------------------------------------------------------------------'
# arange, zeros, ones functions
from numpy import arange, zeros, ones

c = arange(20)          # arange creates an array. range creates a list
print c

c = arange(1, 10, 1)          # arange creates an array. range creates a list
print c

c = arange(1, 10, 0.5)          # arange creates an array. range creates a list
print c

B = arange(9).reshape(3,3) # 2D array
print B

C = zeros((4,3))
print C

C = ones((3,3))
print C
print '------------------------------------------------------------------------'
#-------------------------------------------------------------------------------

# Arithmetic operators
print a+1               # Implicit loop. Adds 1 to each variable
##print a+b               # Error
b = array([5.5, 6.6, 7.7, 8.8])    # redefines array b with elements 5,6,7 and 8
print a+b               # Adds element by element. .+ in matlab
print a-b               # Subtracts element by element. .+ in matlab
print a * b             # multiply each element of a with each element of b
print a ** b            # each element of a is raised to the power of each element of b
print A * B
print '------------------------------------------------------------------------'
# Methods of the ndarray class
print b.min()
print b.max()
print b.sum()
print A.sum(axis=0)     # sum of each column
print A.sum(axis=1)     # sum of each row
print A.shape
print '------------------------------------------------------------------------'
# Universal Functions
from numpy import dot, sqrt, add, mean

print dot(A, B)
print sqrt(dot(A, B))
print add(a, b)
# ceil, floor, round, std, mean, median, var, maximum, minimum, transpose, sum,
# corrcoef, cov, cross, diff, cumsum, sort, sort, ...
print '------------------------------------------------------------------------'
#-------------------------------------------------------------------------------

# Indexing and slicing
print b
print b[0]
print b[0:2]

print A
c = A > mean(A)
print A[c]
print '---'
print A[2,2]
print A[:,2]            # each row in the third column of A
print A[1,:]            # each column in the second row of A
print '------------------------------------------------------------------------'

# Stacking arrays vertically and horizontaly
from numpy import vstack, hstack

print vstack((a,b))
print hstack((a,b))

print '------------------------------------------------------------------------'


#-------------------------------------------------------------------------------
#Read csv file in pure python
import csv

file = open('weight.csv', 'rb')
reader = csv.reader(file)
plcData = []
for row in reader:
    plcData.append(row)

#plcData = array(plcData);

#-------------------------------------------------------------------------------

#Read csv file using NumPy
from numpy import genfromtxt

lcData = genfromtxt('weight.csv', delimiter=',')
n =  lcData.shape[0]

#-------------------------------------------------------------------------------

#matplotlib
#http://matplotlib.org/gallery.html

from pylab import figure, plot, show, legend

figure(3)
style = ['g-', 'b-', 'r-', 'm-', 'k-']
for i in range(0, 4):
    plot(lcData[:,i], style[i])
legend(['Top right', 'Top left', 'Bottom right', 'Bottom left'])
##show()                  # instead of updating the plot in runtime, the users must
                        # implicit call a function to show the plot

#-------------------------------------------------------------------------------

from numpy import std, mean, concatenate, reshape

lcDataSTD = array([])
lcDataMU = array([])
window = 12*3
interval = arange(window, n, window)
for i in interval:
    lcDataSTD = concatenate((lcDataSTD, std(lcData[range(i-(window),i)], 0)))
    lcDataMU = concatenate((lcDataMU, mean(lcData[range(i-(window),i)], 0)))
lcDataSTD = lcDataSTD.reshape((lcDataSTD.shape[0]/5, 5))
lcDataMU = lcDataMU.reshape((lcDataMU.shape[0]/5, 5))

figure(1)
style = ['g:', 'b-', 'r:', 'm:', 'k:']
for i in range(0, lcDataSTD.shape[1]):
    plot(interval, lcDataSTD[:,i], style[i])
legend(['Top right', 'Top left', 'Bottom right', 'Bottom left'])
##show()                  # instead of updating the plot in runtime, the users must
                        # implicit call a function to show the plot
#-------------------------------------------------------------------------------

from pylab import ylim, text, draw

presence = (lcDataSTD[:,1] > 0.01) * 0.2;
protocol = ones((n,1)) * 0.005;         #empty by default
protocol[12*60-1:12*60*3-1] = 0.1;      #laydown
protocol[12*60*4-1:12*60*6-1] = 0.1;    #Sitting side
protocol[12*60*7-1:12*60*9-1] = 0.1;    #Weight Center
protocol[12*60*10-1:12*60*11-1] = 0.1;  #Weight side

figure(2)
for i in range(0, lcDataSTD.shape[1]):
    plot(interval, lcDataSTD[:,i], style[i])
plot(arange(n),protocol, 'm:', linewidth = 3)
plot(interval,presence, 'k-', linewidth = 2)
legend(['Top right', 'Top left', 'Bottom right', 'Bottom left', 'Protocol', 'Presence'])
ylim([0,0.5])

t1 = 0.01
t2 = 0.1
text(12*15, t1, "Empty", size=15)
text(12*60*1.5, t2, "Laying down", size=15)
text(12*60*3.5, t1, "Empty", size=15)
text(12*60*4.5, t2, "Sitting side", size=15)
text(12*60*6.5, t1, "Empty", size=15)
text(12*60*7.5, t2, "Weight Center", size=15)
text(12*60*9.5, t1, "Empty", size=15)
text(12*60*10, t2, "Weight Side", size=15)
text(12*60*11.5, t1, "Empty", size=15)
draw()
show()



